#!/usr/bin/python3
# -*- coding: utf-8 -*-

#
# KeyTalk common constants
#
COMPANY_NAME = "KeyTalk"
PRODUCT_NAME = "KeyTalk"

MAX_PROVIDER_LENGTH = 64
MAX_SERVICE_LENGTH = 64
MAX_USER_ID_LENGTH = 255
MAX_CLIENT_DESC_LENGTH = 64
MAX_PASSWORD_LENGTH = 64
OTP_LENGTH = 6
MAX_CHALLENGE_LENGTH = 64
MAX_RESPONSE_LENGTH = 64
MAX_PINCODE_LENGTH = 64

SUPPORT_EMAIL = "support@keytalk.com"

# @note hardcoded CS for formula "0" as calculated by the client, hardcoded because it is used by the server which cannot call client's CS calculation routines
ZERO_CS = "CS-F7B11509F4D675C3C44F0DD37CA830BB02E8CFA58F04C46283C4BFCBDCE1FF45"

# Credential types
CRED_USERID = "USERID"
CRED_HWSIG = "HWSIG"
CRED_PASSWD = "PASSWD"
CRED_PIN = "PIN"
CRED_RESPONSE = "RESPONSE"
CRED_OTP_MFA = "OTP/MFA"
CREDENTIAL_STRINGS = [CRED_USERID, CRED_HWSIG, CRED_PASSWD, CRED_PIN, CRED_RESPONSE, CRED_OTP_MFA]

# MFA kinds
MFA_KIND_NO_MFA = "no-mfa"
MFA_KIND_POPUPS = "mfa-popups"
MFA_KIND_REDIRECTION = "mfa-redirection"
MFA_KIND_STRINGS = [MFA_KIND_NO_MFA, MFA_KIND_POPUPS, MFA_KIND_REDIRECTION]

CERT_FORMAT_P12 = "P12"
CERT_FORMAT_PEM = "PEM"
CERT_FORMAT_DER = "DER"
CERT_FORMAT_STRINGS = [CERT_FORMAT_P12, CERT_FORMAT_PEM, CERT_FORMAT_DER]

CERTKEY_FORMAT_P12 = "P12"
CERTKEY_FORMAT_P12_V2 = "P12v2"
CERTKEY_FORMAT_PEM = "PEM"
CERTKEY_FORMAT_STRINGS = [CERTKEY_FORMAT_P12, CERTKEY_FORMAT_P12_V2, CERTKEY_FORMAT_PEM]

AUTH_RESULT_OK = "OK"
AUTH_RESULT_DELAY = "DELAY"
AUTH_RESULT_LOCKED = "LOCKED"
AUTH_RESULT_EXPIRED = "EXPIRED"
AUTH_RESULT_KERBEROS_NOK = "KERBEROS-AUTH-NOK"
AUTH_RESULT_CHALLENGE = "CHALLENGE"
AUTH_RESULT_WAIT_FOR_OTP = "WAIT-FOR-OTP"
AUTH_RESULT_STRINGS = [AUTH_RESULT_OK,
                       AUTH_RESULT_DELAY,
                       AUTH_RESULT_LOCKED,
                       AUTH_RESULT_EXPIRED,
                       AUTH_RESULT_KERBEROS_NOK,
                       AUTH_RESULT_CHALLENGE,
                       AUTH_RESULT_WAIT_FOR_OTP,
                       ]

SIGNING_CA = "signing"
EXTRA_SIGNING_CA = "extrasigning"
COMMUNICATION_CA = "communication"
PRIMARY_CA = "primary"
ROOT_CA = "root"
CA_TYPES = [SIGNING_CA, COMMUNICATION_CA, PRIMARY_CA, ROOT_CA, EXTRA_SIGNING_CA]
CA_FN_TYPES = ["Signing CA", "Communication CA", "Primary CA", "Root CA", "Extra Signing CA"]

COMMON_NAME_CUSTOMIZATION_POLICIES = ["ALLOWED",
                                      "DISALLOWED-NOT-SUPPORTED-BY-SERVICE",
                                      "DISALLOWED-CERT-STILL-VALID",
                                      "ALLOWED-AS-GIVENNAME_SURNAME",
                                      ]

TPM_USAGE_STRINGS = ["no", "yes", "yes-with-attestation"]

#
# RCDP common constants
#

RCDPV2_PACKAGED_CERT_EXPORT_PASSWDSIZE = 30
RCDPV2_PASSWORD_NEVER_EXPIRES = -1

RCDPV2_ERR_CODE = \
    {
        # Sent by the server when none of IPs  resolved by the client and by the server match.
        "ErrResolvedIpInvalid": 1001,

        # Sent by server when the client’s calculated executable digest does not
        # much the digest stored on the server.
        "ErrDigestInvalid": 1002,

        # Sent by the server when the client time is out of sync with the server’s time.
        "ErrTimeOutOfSync": 1003,

        # Sent by the server when no certificate can be supplied because the max
        # number of licensed users has been reached
        "ErrMaxLicensedUsersReached": 1004,

        # Sent by the server when the password of the user trying to authenticate
        # is expired but the client is not supposed to start password change
        # procedure
        "ErrPasswordExpired": 1005,

        # Sent by the server when further communication is not possible because the
        # client's API version does not support it (normally too old)
        "ErrIncompatibleProtocolVersion": 1006,

        # Sent by the server to indicate that the TPM Endorsement certificate presented by the client
        # in TPM attestation request is not issued by the TPM Endorsement CA configured on the server
        "ErrTpmEkCertNotIssuedByEkCa": 1007,

        # Sent by the server to indicate that the TPM Endorsement certificate and the public BLOB
        # presented by the client in TPM attestation request do not correspond to each other
        "ErrTpmEkCertMismatchEkPubBlob": 1008,

        # Sent by the server to indicate that the seat supplied by the caller cannot be used for authentication
        # typically because the seat does not exist or is archived or lacks valid certificate
        "ErrInvalidSeat": 1009,
    }

RCDPV2_CERT_CHALLENGES = ["select-globalsign-domainssl-approver-email",
                          "select-globalsign-ssl-approver-email",
                          ]


WEBUI_AND_ADMIN_API_LISTEN_PORT = 3000
RCDP_AND_PUBLIC_API_LISTEN_SSL_PORT = 443
PUBLIC_API_LISTEN_NOSSL_PORT = 80

#
# RCDP v2 constants
#

RCDP_VERSION_2_0 = "2.0.0"
RCDP_VERSION_2_1 = "2.1.0"
RCDP_VERSION_2_2 = "2.2.0"
RCDP_VERSION_2_3 = "2.3.0"
RCDP_VERSION_2_4 = "2.4.0"
RCDP_VERSION_2_4_1 = "2.4.1"
RCDP_VERSION_2_4_2 = "2.4.2"
RCDP_VERSION_2_4_3 = "2.4.3"
RCDP_VERSION_2_4_4 = "2.4.4"
RCDP_VERSION_2_4_5 = "2.4.5"
RCDP_VERSION_2_5_0 = "2.5.0"
RCDP_VERSION_2_5_1 = "2.5.1"
RCDP_VERSION_2_5_2 = "2.5.2"
RCDP_VERSION_2_6_0 = "2.6.0"
RCDP_VERSION_2_7_0 = "2.7.0"
RCDP_VERSION_2_7_1 = "2.7.1"
RCDP_VERSION_2_7_2 = "2.7.2"
RCDP_VERSION_2_7_3 = "2.7.3"
RCDP_VERSION_2_7_4 = "2.7.4"
RCDP_VERSION_2_7_5 = "2.7.5"
RCDP_VERSION_2_7_6 = "2.7.6"
RCDP_VERSION_2_7_7 = "2.7.7"
RCDP_VERSION_2_7_8 = "2.7.8"
RCDP_VERSION_2_7_9 = "2.7.9"
RCDP_VERSION_2_8_0 = "2.8.0"
RCDP_VERSION_2_8_1 = "2.8.1"
RCDP_VERSION_2_8_2 = "2.8.2"
RCDP_VERSION_2_8_3 = "2.8.3"

SERVER_SUPPORTED_RCDPV2_VERSIONS = [RCDP_VERSION_2_0,
                                    RCDP_VERSION_2_1,
                                    RCDP_VERSION_2_2,
                                    RCDP_VERSION_2_3,
                                    RCDP_VERSION_2_4,
                                    RCDP_VERSION_2_4_1,
                                    RCDP_VERSION_2_4_2,
                                    RCDP_VERSION_2_4_3,
                                    RCDP_VERSION_2_4_4,
                                    RCDP_VERSION_2_4_5,
                                    RCDP_VERSION_2_5_0,
                                    RCDP_VERSION_2_5_1,
                                    RCDP_VERSION_2_5_2,
                                    RCDP_VERSION_2_6_0,
                                    RCDP_VERSION_2_7_0,
                                    RCDP_VERSION_2_7_1,
                                    RCDP_VERSION_2_7_2,
                                    RCDP_VERSION_2_7_3,
                                    RCDP_VERSION_2_7_4,
                                    RCDP_VERSION_2_7_5,
                                    RCDP_VERSION_2_7_6,
                                    RCDP_VERSION_2_7_7,
                                    RCDP_VERSION_2_7_8,
                                    RCDP_VERSION_2_7_9,
                                    RCDP_VERSION_2_8_0,
                                    RCDP_VERSION_2_8_1,
                                    RCDP_VERSION_2_8_2,
                                    RCDP_VERSION_2_8_3,
                                    ]

RCDPV2_HTTP_REQUEST_URI_PREFIX = "rcdp"
RCDPV2_HTTP_SID_COOKIE_NAME = "keytalkcookie"

#
# requests
#
RCDPV2_REQUEST_EOC = "eoc"
RCDPV2_REQUEST_ERROR = "error"
RCDPV2_REQUEST_HELLO = "hello"
RCDPV2_REQUEST_HANDSHAKE = "handshake"
RCDPV2_REQUEST_AUTH_REQUIREMENTS = "auth-requirements"
RCDPV2_REQUEST_AUTHENTICATION = "authentication"
RCDPV2_REQUEST_CHANGE_PASSWORD = "change-password"
RCDPV2_REQUEST_LAST_MESSAGES = "last-messages"
RCDPV2_REQUEST_CERT = "cert"
RCDPV2_REQUEST_CSR_REQUIREMENTS = "csr-requirements"
RCDPV2_REQUEST_TPM_ATTESTATION = "tpm-attestation"
RCDPV2_REQUEST_STORE_CERTS = "store-certs"
RCDPV2_REQUEST_SMBCERTS = "smbcerts"
RCDPV2_REQUEST_CERT_SCRAPING_SETTINGS = "cert-scraping-settings"

RCDPV2_REQUEST_STRINGS = [RCDPV2_REQUEST_EOC,
                          RCDPV2_REQUEST_ERROR,
                          RCDPV2_REQUEST_HELLO,
                          RCDPV2_REQUEST_HANDSHAKE,
                          RCDPV2_REQUEST_AUTH_REQUIREMENTS,
                          RCDPV2_REQUEST_AUTHENTICATION,
                          RCDPV2_REQUEST_CHANGE_PASSWORD,
                          RCDPV2_REQUEST_LAST_MESSAGES,
                          RCDPV2_REQUEST_CERT,
                          RCDPV2_REQUEST_CSR_REQUIREMENTS,
                          RCDPV2_REQUEST_TPM_ATTESTATION,
                          RCDPV2_REQUEST_STORE_CERTS,
                          RCDPV2_REQUEST_SMBCERTS,
                          RCDPV2_REQUEST_CERT_SCRAPING_SETTINGS,
                          ]

RCDPV2_REQUEST_PARAM_NAME_CALLER_APP_DESCRIPTION = "caller-app-description"
RCDPV2_REQUEST_PARAM_NAME_CALLER_HW_DESCRIPTION = "caller-hw-description"
RCDPV2_REQUEST_PARAM_NAME_ERROR_CODE = "code"
RCDPV2_REQUEST_PARAM_NAME_ERROR_DESCRIPTION = "description"
RCDPV2_REQUEST_PARAM_NAME_REASON = "reason"
RCDPV2_REQUEST_PARAM_NAME_CALLER_UTC = "caller-utc"
RCDPV2_REQUEST_PARAM_NAME_SERVICE = "service"
RCDPV2_REQUEST_PARAM_NAME_LAST_MESSAGES_FROM_UTC = "from-utc"
RCDPV2_REQUEST_PARAM_NAME_CERTKEY_FORMAT = "format"
RCDPV2_REQUEST_PARAM_NAME_CERT_OUT_OF_BAND = "out-of-band"
RCDPV2_REQUEST_PARAM_NAME_CSR = "csr"
RCDPV2_REQUEST_PARAM_NAME_RESOLVED = "resolved"
RCDPV2_REQUEST_PARAM_NAME_DIGESTS = "digests"
RCDPV2_REQUEST_PARAM_NAME_URI = "uri"
RCDPV2_REQUEST_PARAM_NAME_IPS = "ips"
RCDPV2_REQUEST_PARAM_NAME_DIGEST = "digest"
RCDPV2_REQUEST_PARAM_NAME_RESPONSE = "response"
RCDPV2_REQUEST_PARAM_NAME_RESPONSES = "responses"
RCDPV2_REQUEST_PARAM_NAME_NAME = "name"
RCDPV2_REQUEST_PARAM_NAME_VALUE = "value"
RCDPV2_REQUEST_PARAM_NAME_OLD_PASSWORD = "old-password"
RCDPV2_REQUEST_PARAM_NAME_NEW_PASSWORD = "new-password"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET = "kerberos-ticket"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_CLIENT_PRINCIPAL = "client-principal"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_SESSION_KEY = "session-key"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_SESSION_KEY_ENCODING = "session-key-encoding"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_TGT = "tgt"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_TGT_FLAGS = "tgt-flags"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_START_TIME = "start-time"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_END_TIME = "end-time"
RCDPV2_REQUEST_PARAM_NAME_KERBEROS_TICKET_RENEW_TILL = "renew-till"
RCDPV2_REQUEST_PARAM_NAME_COMPUTER_NAME = "computer-name"
RCDPV2_REQUEST_PARAM_NAME_RETIRED_COMPUTER_NAME = "retired-computer-name"
RCDPV2_REQUEST_PARAM_NAME_TYPE = "type"
RCDPV2_REQUEST_PARAM_NAME_DATA = "data"
RCDPV2_REQUEST_PARAM_NAME_COOKIE = "cookie"
RCDPV2_REQUEST_PARAM_NAME_COMMON_NAME = "common-name"
RCDPV2_REQUEST_PARAM_NAME_GIVEN_NAME = "given-name"
RCDPV2_REQUEST_PARAM_NAME_SURNAME = "surname"
RCDPV2_REQUEST_PARAM_NAME_EK_CERT = "ek-cert"
RCDPV2_REQUEST_PARAM_NAME_EK_PUB_BLOB = "ek-pub-blob"
RCDPV2_REQUEST_PARAM_NAME_AK_NAME = "ak-name"
RCDPV2_REQUEST_PARAM_NAME_TPM_EVIDENCE = "tpm-evidence"
RCDPV2_REQUEST_PARAM_NAME_CERTIFICATES = "certificates"
RCDPV2_REQUEST_PARAM_NAME_SEAT = "seat"
RCDPV2_REQUEST_PARAM_NAME_SAN_DOMAINS = "san-domains"

#
# responses
#
RCDPV2_RESPONSE_EOC = "eoc"
RCDPV2_RESPONSE_ERROR = "error"
RCDPV2_RESPONSE_HELLO = "hello"
RCDPV2_RESPONSE_HANDSHAKE = "handshake"
RCDPV2_RESPONSE_AUTH_REQUIREMENTS = "auth-requirements"
RCDPV2_RESPONSE_AUTH_RESULT = "auth-result"
RCDPV2_RESPONSE_LAST_MESSAGES = "last-messages"
RCDPV2_RESPONSE_CERT = "cert"
RCDPV2_RESPONSE_CSR_REQUIREMENTS = "csr-requirements"
RCDPV2_RESPONSE_CHALLENGE = "challenge"
RCDPV2_RESPONSE_SUBMITTED = "submitted"
RCDPV2_RESPONSE_IN_PROGRESS = "in-progress"
RCDPV2_RESPONSE_PENDING_APPROVAL = "pending-approval"
RCDPV2_RESPONSE_TPM_ATTESTATION = "tpm-attestation"
RCDPV2_RESPONSE_STORE_CERTS = "store-certificates"
RCDPV2_RESPONSE_SMBCERTS = "smbcerts"
RCDPV2_RESPONSE_CERT_SCRAPING_SETTINGS = "cert-scraping-settings"

RCDPV2_RESPONSE_STRINGS = [RCDPV2_RESPONSE_EOC,
                           RCDPV2_RESPONSE_ERROR,
                           RCDPV2_RESPONSE_HELLO,
                           RCDPV2_RESPONSE_HANDSHAKE,
                           RCDPV2_RESPONSE_AUTH_REQUIREMENTS,
                           RCDPV2_RESPONSE_AUTH_RESULT,
                           RCDPV2_RESPONSE_LAST_MESSAGES,
                           RCDPV2_RESPONSE_CERT,
                           RCDPV2_RESPONSE_CSR_REQUIREMENTS,
                           RCDPV2_RESPONSE_CHALLENGE,
                           RCDPV2_RESPONSE_SUBMITTED,
                           RCDPV2_RESPONSE_IN_PROGRESS,
                           RCDPV2_RESPONSE_PENDING_APPROVAL,
                           RCDPV2_RESPONSE_TPM_ATTESTATION,
                           RCDPV2_RESPONSE_STORE_CERTS,
                           RCDPV2_RESPONSE_SMBCERTS,
                           RCDPV2_RESPONSE_CERT_SCRAPING_SETTINGS,
                           ]

RCDPV2_RESPONSE_PARAM_NAME_STATUS = "status"
RCDPV2_RESPONSE_PARAM_NAME_ERROR_CODE = "code"
RCDPV2_RESPONSE_PARAM_NAME_ERROR_DESCRIPTION = "description"
RCDPV2_RESPONSE_PARAM_NAME_VERSION = "version"
RCDPV2_RESPONSE_PARAM_NAME_REASON = "reason"
RCDPV2_RESPONSE_PARAM_NAME_SERVER_UTC = "server-utc"
RCDPV2_RESPONSE_PARAM_NAME_CRED_TYPES = "credential-types"
RCDPV2_RESPONSE_PARAM_NAME_HWSIG_FORMULA = "hwsig_formula"
RCDPV2_RESPONSE_PARAM_NAME_PASSWORD_PROMPT = "password-prompt"
RCDPV2_RESPONSE_PARAM_NAME_CHALLENGES = "challenges"
RCDPV2_RESPONSE_PARAM_NAME_NAME = "name"
RCDPV2_RESPONSE_PARAM_NAME_VALUE = "value"
RCDPV2_RESPONSE_PARAM_NAME_RESPONSE_NAMES = "response-names"
RCDPV2_RESPONSE_PARAM_NAME_AUTH_STATUS = "auth-status"
RCDPV2_RESPONSE_PARAM_NAME_PASSWORD_VALIDITY = "password-validity"
RCDPV2_RESPONSE_PARAM_NAME_DELAY = "delay"
RCDPV2_RESPONSE_PARAM_NAME_MESSAGES = "messages"
RCDPV2_RESPONSE_PARAM_NAME_UTC = "utc"
RCDPV2_RESPONSE_PARAM_NAME_TEXT = "text"
RCDPV2_RESPONSE_PARAM_NAME_CERT = "cert"
RCDPV2_RESPONSE_PARAM_NAME_CHALLENGE_TYPE = "challenge-type"
RCDPV2_RESPONSE_PARAM_NAME_CHALLENGE_DATA = "challenge-data"
RCDPV2_RESPONSE_PARAM_NAME_CERT_URL_TEMPL = "cert-url-templ"
RCDPV2_RESPONSE_PARAM_NAME_SERVICE_URIS = "service-uris"
RCDPV2_RESPONSE_PARAM_NAME_RESOLVE_SERVICE_URIS = "resolve-service-uris"
RCDPV2_RESPONSE_PARAM_NAME_CALC_SERVICE_URIS_DIGEST = "calc-service-uris-digest"
RCDPV2_RESPONSE_PARAM_NAME_USE_TPM_VSC_AUTHENTICATION = "use-tpm-vsc-authentication"
RCDPV2_RESPONSE_PARAM_NAME_USE_KERBEROS_AUTHENTICATION = "use-kerberos-authentication"
RCDPV2_RESPONSE_PARAM_NAME_SUPPLY_COMPUTER_NAME = "supply-computer-name"
RCDPV2_RESPONSE_PARAM_NAME_EXECUTE_SYNC = "execute-sync"
RCDPV2_RESPONSE_PARAM_NAME_KEY_SIZE = "key-size"
RCDPV2_RESPONSE_PARAM_NAME_SIGNING_ALGO = "signing-algo"
RCDPV2_RESPONSE_PARAM_NAME_SUBJECT = "subject"
RCDPV2_RESPONSE_PARAM_NAME_SAN = "san"
RCDPV2_RESPONSE_PARAM_NAME_KU = "ku"
RCDPV2_RESPONSE_PARAM_NAME_EKU = "eku"
RCDPV2_RESPONSE_PARAM_NAME_CERT_STORE_TO_SYSTEM = "store-to-system"
RCDPV2_RESPONSE_PARAM_NAME_ADDRESS_BOOKS = "address-books"
RCDPV2_RESPONSE_PARAM_NAME_APPLY_ADDRESS_BOOKS = "apply-address-books"
RCDPV2_RESPONSE_PARAM_NAME_APPLY_SMIME_SETTINGS = "apply-smime-settings"
RCDPV2_RESPONSE_PARAM_NAME_LDAP_SVR_URL = "dap-svr-url"
RCDPV2_RESPONSE_PARAM_NAME_SEARCH_BASE = "search-base"
RCDPV2_RESPONSE_PARAM_NAME_VERIFICATION_CA = "verification-ca"
RCDPV2_RESPONSE_PARAM_NAME_SET_DISCLAIMER = "set-disclaimer"
RCDPV2_RESPONSE_PARAM_NAME_MFA_SETTINGS = "mfa-settings"
RCDPV2_RESPONSE_PARAM_NAME_MFA_KIND = "kind"
RCDPV2_RESPONSE_PARAM_NAME_MFA_CLIENT_ID = "client-id"
RCDPV2_RESPONSE_PARAM_NAME_MFA_AUTHORITY = "authority"
RCDPV2_RESPONSE_PARAM_NAME_MFA_SCOPES = "scopes"
RCDPV2_RESPONSE_PARAM_NAME_MFA_REDIRECT_URI = "redirect-uri"
RCDPV2_RESPONSE_PARAM_NAME_MFA_POST_LOG_OUT_URI = "post-log-out-uri"
RCDPV2_RESPONSE_PARAM_NAME_ENCRYPTED_CHALLENGE = "encrypted-challenge"
RCDPV2_RESPONSE_PARAM_NAME_SMBCERTS = "smbcerts"
RCDPV2_RESPONSE_PARAM_NAME_UPN = "upn"
RCDPV2_RESPONSE_PARAM_NAME_SCHEDULE = "schedule"
RCDPV2_RESPONSE_PARAM_NAME_CERT_PURPOSES = "cert-purposes"
RCDPV2_RESPONSE_PARAM_NAME_CERT_STORE_TYPES = "cert-store-types"

# backwards compatibility with 2.4.5
RCDPV2_RESPONSE_PARAM_NAME_SIGNATURE = "signature"
RCDPV2_RESPONSE_PARAM_NAME_SIGNATURE_NAME = "name"
RCDPV2_RESPONSE_PARAM_NAME_SIGNATURE_ZIP = "zip"
RCDPV2_RESPONSE_PARAM_NAME_DETAILS = "details"
RCDPV2_RESPONSE_PARAM_NAME_COOKIE = "cookie"
RCDPV2_RESPONSE_PARAM_NAME_APPROVAL_ONGOING = "approval-ongoing"
RCDPV2_RESPONSE_PARAM_NAME_HISTORICAL_CERTS = "historical-certs"
RCDPV2_RESPONSE_PARAM_NAME_HISTORICAL_CERTS_URL_TEMPL = "historical-certs-url-templ"
RCDPV2_RESPONSE_PARAM_NAME_CHALLENGE = "challenge"
RCDPV2_RESPONSE_PARAM_NAME_STORED = "stored"
RCDPV2_RESPONSE_PARAM_NAME_SKIPPED = "skipped"


RCDPV2_STATE_STRINGS = ["closed", "hello", "connected", "pending-response", "authenticated"]


#
# CA API constants
#
CA_API_VERSION_1_0 = "1.0.0"
CA_API_VERSION_1_0_1 = "1.0.1"
CA_API_VERSION_1_0_2 = "1.0.2"
CA_API_VERSION_1_0_3 = "1.0.3"
SERVER_SUPPORTED_CA_API_VERSIONS = [CA_API_VERSION_1_0, CA_API_VERSION_1_0_1, CA_API_VERSION_1_0_2, CA_API_VERSION_1_0_3]
# CA API listen ports are shared with cert download to minimize the number of open ports
CA_API_AND_CERT_DOWNLOAD_NOSSL_LISTEN_PORT = 80
CA_API_AND_CERT_DOWNLOAD_SSL_LISTEN_PORT = 443
CA_API_REQUEST_SCRIPT_NAME = "ca"

CA_API_CERT_FORMAT_PEM="pem"
CA_API_CERT_FORMAT_DER="der"
CA_API_CERT_FORMATS = [CA_API_CERT_FORMAT_PEM, CA_API_CERT_FORMAT_DER]

#
# Certificate download constants
#
CERT_DOWNLOAD_URL_HOST_PLACEHOLDER = "KEYTALK_SVR_HOST"
CERT_DOWNLOAD_REQUEST_SCRIPT_NAME = "cert"
HISTORICAL_CERTS_DOWNLOAD_REQUEST_SCRIPT_NAME = "historical-certs"
CRL_DOWNLOAD_REQUEST_SCRIPT_NAME = "crl"
SMIME_CERT_FOR_EXT_USER_DOWNLOAD_REQUEST_SCRIPT_NAME = "smime"


#
# Public API constants
#
PUBLIC_API_VERSION_1_0 = "1.0.0"
PUBLIC_API_VERSION_1_1 = "1.1.0"
PUBLIC_API_VERSION_1_2 = "1.2.0"
PUBLIC_API_VERSION_1_2_1 = "1.2.1"
PUBLIC_API_VERSION_1_3_0 = "1.3.0"
PUBLIC_API_VERSION_1_4_0 = "1.4.0"
PUBLIC_API_VERSION_1_5_0 = "1.5.0"
PUBLIC_API_VERSION_1_6_0 = "1.6.0"
PUBLIC_API_VERSION_1_6_1 = "1.6.1"
PUBLIC_API_VERSION_1_6_2 = "1.6.2"
PUBLIC_API_VERSION_1_6_3 = "1.6.3"
PUBLIC_API_VERSION_1_6_4 = "1.6.4"
PUBLIC_API_VERSION_1_6_5 = "1.6.5"
PUBLIC_API_VERSION_1_6_6 = "1.6.6"
PUBLIC_API_VERSION_1_6_7 = "1.6.7"
PUBLIC_API_VERSION_1_6_8 = "1.6.8"
PUBLIC_API_VERSION_1_6_9 = "1.6.9"
SERVER_SUPPORTED_PUBLIC_API_VERSIONS = [PUBLIC_API_VERSION_1_0,
                                        PUBLIC_API_VERSION_1_1,
                                        PUBLIC_API_VERSION_1_2,
                                        PUBLIC_API_VERSION_1_2_1,
                                        PUBLIC_API_VERSION_1_3_0,
                                        PUBLIC_API_VERSION_1_4_0,
                                        PUBLIC_API_VERSION_1_5_0,
                                        PUBLIC_API_VERSION_1_6_0,
                                        PUBLIC_API_VERSION_1_6_1,
                                        PUBLIC_API_VERSION_1_6_2,
                                        PUBLIC_API_VERSION_1_6_3,
                                        PUBLIC_API_VERSION_1_6_4,
                                        PUBLIC_API_VERSION_1_6_5,
                                        PUBLIC_API_VERSION_1_6_6,
                                        PUBLIC_API_VERSION_1_6_7,
                                        PUBLIC_API_VERSION_1_6_8,
                                        PUBLIC_API_VERSION_1_6_9,
                                        ]
PUBLIC_API_REQUEST_SCRIPT_NAME = "public"

PUBLIC_API_REQUEST_SELF_SERVICE_AVAILABILITY = "self-service-availability"
PUBLIC_API_REQUEST_ADDRESS_BOOK_LIST = "address-book-list"
PUBLIC_API_REQUEST_SMIME_CERT_ENROLLMENT_AVAILABILITY = "smime-cert-enrollment-availability"
PUBLIC_API_REQUEST_SHOULD_CERT_GO_TO_SYSTEM_STORE = "should-cert-go-to-system-store"
PUBLIC_API_REQUEST_SET_SIGNATURE_FOR_SMIME_CERT_EMAIL = "set-signature-for-smime-cert-email"
PUBLIC_API_REQUEST_SET_DISCLAIMER_FOR_SMIME_CERT_EMAIL = "set-disclaimer-for-smime-cert-email"
PUBLIC_API_REQUEST_CERT_APPROVER_EMAILS = "cert-approver-emails"
PUBLIC_API_REQUEST_VERSION = "version"
PUBLIC_API_REQUEST_COMMON_NAME_CUSTOMIZATION_POLICY = "cn-customization-policy"
PUBLIC_API_REQUEST_TEMPLATES_TO_AUTO_RENEW_SEAT_CERTS = "templates-to-auto-renew-seat-certs"
PUBLIC_API_REQUEST_CERT_EXPIRATION_MARGIN = "cert-expiration-margin"
PUBLIC_API_REQUEST_RCCD = "rccd"
PUBLIC_API_REQUEST_HEALTH_CHECK = "health-check"
PUBLIC_API_REQUEST_KTAGENT_UNATTENDED_POPUP_MSG_TEMPLATE = "ktagent-unattended-popup-msg-template"
PUBLIC_API_REQUEST_KEEP_ALIVE_INTERVAL = "keep-alive-interval"
PUBLIC_API_REQUEST_I_AM_ALIVE = "i-am-alive"
PUBLIC_API_REQUEST_IS_CERT_TPM_ATTESTED = "is-cert-tpm-attested"

PUBLIC_API_REQUEST_STRINGS = [PUBLIC_API_REQUEST_SELF_SERVICE_AVAILABILITY,
                              PUBLIC_API_REQUEST_ADDRESS_BOOK_LIST,
                              PUBLIC_API_REQUEST_SMIME_CERT_ENROLLMENT_AVAILABILITY,
                              PUBLIC_API_REQUEST_SHOULD_CERT_GO_TO_SYSTEM_STORE,
                              PUBLIC_API_REQUEST_SET_SIGNATURE_FOR_SMIME_CERT_EMAIL,
                              PUBLIC_API_REQUEST_SET_DISCLAIMER_FOR_SMIME_CERT_EMAIL,
                              PUBLIC_API_REQUEST_CERT_APPROVER_EMAILS,
                              PUBLIC_API_REQUEST_VERSION,
                              PUBLIC_API_REQUEST_COMMON_NAME_CUSTOMIZATION_POLICY,
                              PUBLIC_API_REQUEST_TEMPLATES_TO_AUTO_RENEW_SEAT_CERTS,
                              PUBLIC_API_REQUEST_CERT_EXPIRATION_MARGIN,
                              PUBLIC_API_REQUEST_RCCD,
                              PUBLIC_API_REQUEST_HEALTH_CHECK,
                              PUBLIC_API_REQUEST_KTAGENT_UNATTENDED_POPUP_MSG_TEMPLATE,
                              PUBLIC_API_REQUEST_KEEP_ALIVE_INTERVAL,
                              PUBLIC_API_REQUEST_I_AM_ALIVE,
                              PUBLIC_API_REQUEST_IS_CERT_TPM_ATTESTED,
                              ]

PUBLIC_API_REQUEST_PARAM_NAME_CERT = "cert"
PUBLIC_API_REQUEST_PARAM_NAME_SERVICE = "service"
PUBLIC_API_REQUEST_PARAM_NAME_SYNCHRONOUS = "synchronous"
PUBLIC_API_REQUEST_PARAM_NAME_EMAIL = "email"
PUBLIC_API_REQUEST_PARAM_NAME_USER = "user"
PUBLIC_API_REQUEST_PARAM_NAME_COMPUTER_NAME = "computer-name"
PUBLIC_API_REQUEST_PARAM_NAME_TEMPLATE_NAME = "template-name"
PUBLIC_API_REQUEST_PARAM_NAME_TEMPLATE_NAMES = "template-names"
PUBLIC_API_REQUEST_PARAM_NAME_UID = "uid"
PUBLIC_API_REQUEST_PARAM_NAME_CERT_SHA1_FINGERPRINT = "cert-sha1-fingerprint"

PUBLIC_API_RESPONSE_SELF_SERVICE_AVAILABILITY = "self-service-availability"
PUBLIC_API_RESPONSE_ADDRESS_BOOK_LIST = "address-book-list"
PUBLIC_API_RESPONSE_SMIME_CERT_ENROLLMENT_AVAILABILITY = "smime-cert-enrollment-availability"
PUBLIC_API_RESPONSE_SHOULD_CERT_GO_TO_SYSTEM_STORE = "should-cert-go-to-system-store"
PUBLIC_API_RESPONSE_SET_SIGNATURE_FOR_SMIME_CERT_EMAIL = "set-signature-for-smime-cert-email"
PUBLIC_API_RESPONSE_SET_DISCLAIMER_FOR_SMIME_CERT_EMAIL = "set-disclaimer-for-smime-cert-email"
PUBLIC_API_RESPONSE_CERT_APPROVER_EMAILS = "cert-approver-emails"
PUBLIC_API_RESPONSE_VERSION = "version"
PUBLIC_API_RESPONSE_COMMON_NAME_CUSTOMIZATION_POLICY = "cn-customization-policy"
PUBLIC_API_RESPONSE_TEMPLATES_TO_AUTO_RENEW_SEAT_CERTS = "templates-to-auto-renew-seat-certs"
PUBLIC_API_RESPONSE_CERT_EXPIRATION_MARGIN = "cert-expiration-margin"
PUBLIC_API_RESPONSE_HEALTH_CHECK = "health-check"
PUBLIC_API_RESPONSE_KTAGENT_UNATTENDED_POPUP_MSG_TEMPLATE = "ktagent-unattended-popup-msg-template"
PUBLIC_API_RESPONSE_KEEP_ALIVE_INTERVAL = "keep-alive-interval"
PUBLIC_API_RESPONSE_SUCCESS = "success"
PUBLIC_API_RESPONSE_ERROR = "error"

PUBLIC_API_RESPONSE_STRINGS = [PUBLIC_API_RESPONSE_SELF_SERVICE_AVAILABILITY,
                               PUBLIC_API_RESPONSE_ADDRESS_BOOK_LIST,
                               PUBLIC_API_RESPONSE_SMIME_CERT_ENROLLMENT_AVAILABILITY,
                               PUBLIC_API_RESPONSE_SHOULD_CERT_GO_TO_SYSTEM_STORE,
                               PUBLIC_API_RESPONSE_SET_SIGNATURE_FOR_SMIME_CERT_EMAIL,
                               PUBLIC_API_RESPONSE_SET_DISCLAIMER_FOR_SMIME_CERT_EMAIL,
                               PUBLIC_API_RESPONSE_CERT_APPROVER_EMAILS,
                               PUBLIC_API_RESPONSE_VERSION,
                               PUBLIC_API_RESPONSE_COMMON_NAME_CUSTOMIZATION_POLICY,
                               PUBLIC_API_RESPONSE_TEMPLATES_TO_AUTO_RENEW_SEAT_CERTS,
                               PUBLIC_API_RESPONSE_CERT_EXPIRATION_MARGIN,
                               PUBLIC_API_RESPONSE_HEALTH_CHECK,
                               PUBLIC_API_RESPONSE_KTAGENT_UNATTENDED_POPUP_MSG_TEMPLATE,
                               PUBLIC_API_RESPONSE_KEEP_ALIVE_INTERVAL,
                               PUBLIC_API_RESPONSE_SUCCESS,
                               PUBLIC_API_RESPONSE_ERROR,
                               ]

PUBLIC_API_RESPONSE_PARAM_NAME_ERROR = "error"
PUBLIC_API_RESPONSE_PARAM_NAME_STATUS = "status"
PUBLIC_API_RESPONSE_PARAM_NAME_AVAILABLE = "available"
PUBLIC_API_RESPONSE_PARAM_NAME_MOBILE_REQUIRED = "mobile-required"
PUBLIC_API_RESPONSE_PARAM_NAME_REASON = "reason"
PUBLIC_API_RESPONSE_PARAM_NAME_ADDRESS_BOOKS = "address-books"
PUBLIC_API_RESPONSE_PARAM_NAME_LDAP_SVR_URL = "ldap_svr_url"
PUBLIC_API_RESPONSE_PARAM_NAME_SEARCH_BASE = "search_base"
PUBLIC_API_RESPONSE_PARAM_NAME_VERIFICATION_CA = "verification_ca"
PUBLIC_API_RESPONSE_PARAM_NAME_APPLY_ADDRESS_BOOKS = "apply-address-books"
PUBLIC_API_RESPONSE_PARAM_NAME_SYSTEM_STORE = "system-store"
PUBLIC_API_RESPONSE_PARAM_NAME_SET_SIGNATURE = "set-signature"
PUBLIC_API_RESPONSE_PARAM_NAME_SIGNATURE = "signature"
PUBLIC_API_RESPONSE_PARAM_NAME_SET_DISCLAIMER = "set-disclaimer"
PUBLIC_API_RESPONSE_PARAM_NAME_DISCLAIMER = "disclaimer"
PUBLIC_API_RESPONSE_PARAM_NAME_DISCLAIMER_NAME = "name"
PUBLIC_API_RESPONSE_PARAM_NAME_DISCLAIMER_ZIP = "zip"
PUBLIC_API_RESPONSE_PARAM_NAME_DISCLAIMER_CHECK_INTERVAL = "check-interval"
PUBLIC_API_RESPONSE_PARAM_NAME_EMAILS = "emails"
PUBLIC_API_RESPONSE_PARAM_NAME_VERSION = "version"
PUBLIC_API_RESPONSE_PARAM_NAME_POLICY = "policy"
PUBLIC_API_RESPONSE_PARAM_NAME_TEMPLATE_NAMES = "template-names"
PUBLIC_API_RESPONSE_PARAM_NAME_THRESHOLD_SECONDS = "threshold-seconds"
PUBLIC_API_RESPONSE_PARAM_NAME_CHECK_RESULT = "check-result"
PUBLIC_API_RESPONSE_PARAM_NAME_MSG_TEMPLATE = "msg-template"
PUBLIC_API_RESPONSE_PARAM_NAME_INTERVAL = "interval"
PUBLIC_API_RESPONSE_PARAM_NAME_ATTESTED = "attested"
PUBLIC_API_RESPONSE_PARAM_NAME_YES = "yes"
PUBLIC_API_RESPONSE_PARAM_NAME_NO = "no"

PUBLIC_API_HEALTH_CHECK_RESULT_OPERATIONAL = "operational"
PUBLIC_API_HEALTH_CHECK_RESULT_ERROR = "error"
PUBLIC_API_HEALTH_CHECK_RESULT_STRINGS = [PUBLIC_API_HEALTH_CHECK_RESULT_OPERATIONAL,
                                         PUBLIC_API_HEALTH_CHECK_RESULT_ERROR,
                               ]

#
# Self-service API constants
#
SELF_SERVICE_API_VERSION_1_0 = "1.0.0"
SELF_SERVICE_API_VERSION_1_1 = "1.1.0"
SELF_SERVICE_API_VERSION_1_1_1 = "1.1.1"
SERVER_SUPPORTED_SELF_SERVICE_API_VERSIONS = [SELF_SERVICE_API_VERSION_1_0,
                                              SELF_SERVICE_API_VERSION_1_1,
                                              SELF_SERVICE_API_VERSION_1_1_1,
                                        ]
SELF_SERVICE_API_REQUEST_SCRIPT_NAME = "ssapi"

SELF_SERVICE_API_REQUEST_SMIME_CERT_ENROLLMENT = "smime-cert-enrollment"
SELF_SERVICE_API_REQUEST_STRINGS = [SELF_SERVICE_API_REQUEST_SMIME_CERT_ENROLLMENT,
                              ]
SELF_SERVICE_API_REQUEST_PARAM_NAME_RECIPIENTS = "recipients"
SELF_SERVICE_API_REQUEST_PARAM_NAME_EMAIL = "email"
SELF_SERVICE_API_REQUEST_PARAM_NAME_MOBILE = "mobile"
SELF_SERVICE_API_REQUEST_PARAM_NAME_SVR_HOST_NAME = "svr-host-name"
SELF_SERVICE_API_REQUEST_PARAM_NAME_SYNCHRONOUS = "synchronous"

SELF_SERVICE_API_RESPONSE_SMIME_CERT_ENROLLMENT = "smime-cert-enrollment"
SELF_SERVICE_API_RESPONSE_ERROR = "error"
SELF_SERVICE_API_RESPONSE_STRINGS = [SELF_SERVICE_API_RESPONSE_SMIME_CERT_ENROLLMENT,
                               SELF_SERVICE_API_RESPONSE_ERROR,
                               ]
SELF_SERVICE_API_RESPONSE_PARAM_NAME_STATUS = "status"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_ERROR = "error"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_ENROLLED_RECIPIENTS = "enrolled-recipients"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_FAILED_RECIPIENTS = "failed-recipients"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_SKIPPED_RECIPIENTS = "skipped-recipients"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_PLACED_ORDERS = "enrolled-orders"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_FAILED_ORDERS = "failed-orders"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_SKIPPED_ORDERS = "skipped-orders"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_EMAIL = "email"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_ORDER_ID = "order-id"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_ADDRESS_BOOKS = "address-books"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_APPLY_ADDRESS_BOOKS = "apply-address-books"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_LDAP_SVR_URL = "ldap-svr-url"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_SEARCH_BASE = "search-base"
SELF_SERVICE_API_RESPONSE_PARAM_NAME_VERIFICATION_CA = "verification-ca"

#
# Admin API constants
#
ADMIN_API_VERSION_1_0 = "1.0.0"
ADMIN_API_VERSION_1_1 = "1.1.0"
ADMIN_API_VERSION_1_2 = "1.2.0"
ADMIN_API_VERSION_1_3 = "1.3.0"
ADMIN_API_VERSION_1_4 = "1.4.0"
ADMIN_API_VERSION_1_5 = "1.5.0"
ADMIN_API_VERSION_1_6 = "1.6.0"
ADMIN_API_VERSION_1_7 = "1.7.0"
ADMIN_API_VERSION_1_8 = "1.8.0"
ADMIN_API_VERSION_1_8_1 = "1.8.1"
ADMIN_API_VERSION_1_9 = "1.9"
ADMIN_API_VERSION_1_9_1 = "1.9.1"
ADMIN_API_VERSION_1_9_2 = "1.9.2"
ADMIN_API_VERSION_1_9_3 = "1.9.3"
ADMIN_API_VERSION_1_9_4 = "1.9.4"
ADMIN_API_VERSION_1_9_5 = "1.9.5"
ADMIN_API_VERSION_1_9_6 = "1.9.6"
SERVER_SUPPORTED_ADMIN_API_VERSIONS = [ADMIN_API_VERSION_1_0,
                                       ADMIN_API_VERSION_1_1,
                                       ADMIN_API_VERSION_1_2,
                                       ADMIN_API_VERSION_1_3,
                                       ADMIN_API_VERSION_1_4,
                                       ADMIN_API_VERSION_1_5,
                                       ADMIN_API_VERSION_1_6,
                                       ADMIN_API_VERSION_1_7,
                                       ADMIN_API_VERSION_1_8,
                                       ADMIN_API_VERSION_1_8_1,
                                       ADMIN_API_VERSION_1_9,
                                       ADMIN_API_VERSION_1_9_1,
                                       ADMIN_API_VERSION_1_9_2,
                                       ADMIN_API_VERSION_1_9_3,
                                       ADMIN_API_VERSION_1_9_4,
                                       ADMIN_API_VERSION_1_9_5,
                                       ADMIN_API_VERSION_1_9_6,
                                    ]
ADMIN_API_REQUEST_SCRIPT_NAME = "admapi"

ADMIN_API_REQUEST_CERT_REVOCATION = "cert-revocation"
ADMIN_API_REQUEST_CERT_ENROLLMENT = "cert-enrollment"
ADMIN_API_REQUEST_CERT_ENROLLMENT_FOR_CSR = "cert-enrollment-for-csr"
# ACME cert enrollment API is currently used by KeyTalk ACME Daemon only
# hence we do not bother publishing it in the API spec
ADMIN_API_REQUEST_ACME_CERT_ENROLLMENT = "acme-cert-enrollment"
ADMIN_API_REQUEST_CREATE_DIGICERT_DV_ACME_TEMPLATE = "create-digicert-dv-acme-template"
ADMIN_API_REQUEST_CSR_ENROLLMENT_REQUIREMENTS = "csr-enrolment-requirements"
ADMIN_API_REQUEST_KEYTALK_SETTINGS = "settings"
ADMIN_API_REQUEST_INTUNE_SCEP_CONFIGURATION = "intune-scep-config"
ADMIN_API_REQUEST_COPY_TEMPLATE = "copy-template"
ADMIN_API_REQUEST_IMPORT_CERTS = "import-certs"
ADMIN_API_REQUEST_ARCHIVE_SEAT = "archive-seat"
ADMIN_API_REQUEST_LIST_TEMPLATES = "list-templates"
ADMIN_API_REQUEST_REMOVE_TEMPLATE = "remove-template"
ADMIN_API_REQUEST_OPEN_SLOT = "open-slot"
ADMIN_API_REQUEST_CREATE_INTERNAL_RA_USER = "create-internal-ra-user"
ADMIN_API_REQUEST_UPDATE_SEATS = "update-seats"
ADMIN_API_REQUEST_REMOVE_SEAT = "remove-seat"
ADMIN_API_REQUEST_REPORT_SEAT_ENROLLMENT_ERROR = "report-seat-enrollment-error"
ADMIN_API_REQUEST_CREATE_TENANT = "create-tenant"
ADMIN_API_REQUEST_ENABLE_ACME = "enable-acme"
ADMIN_API_REQUEST_CREATE_SEAT = "create-seat"
ADMIN_API_REQUEST_STRINGS = [ADMIN_API_REQUEST_CERT_REVOCATION,
                             ADMIN_API_REQUEST_CERT_ENROLLMENT,
                             ADMIN_API_REQUEST_CSR_ENROLLMENT_REQUIREMENTS,
                             ADMIN_API_REQUEST_CERT_ENROLLMENT_FOR_CSR,
                             ADMIN_API_REQUEST_KEYTALK_SETTINGS,
                             ADMIN_API_REQUEST_INTUNE_SCEP_CONFIGURATION,
                             ADMIN_API_REQUEST_COPY_TEMPLATE,
                             ADMIN_API_REQUEST_IMPORT_CERTS,
                             ADMIN_API_REQUEST_ARCHIVE_SEAT,
                             ADMIN_API_REQUEST_LIST_TEMPLATES,
                             ADMIN_API_REQUEST_REMOVE_TEMPLATE,
                             ADMIN_API_REQUEST_OPEN_SLOT,
                             ADMIN_API_REQUEST_CREATE_INTERNAL_RA_USER,
                             ADMIN_API_REQUEST_UPDATE_SEATS,
                             ADMIN_API_REQUEST_REMOVE_SEAT,
                             ADMIN_API_REQUEST_ACME_CERT_ENROLLMENT,
                             ADMIN_API_REQUEST_CREATE_DIGICERT_DV_ACME_TEMPLATE,
                             ADMIN_API_REQUEST_REPORT_SEAT_ENROLLMENT_ERROR,
                             ADMIN_API_REQUEST_CREATE_TENANT,
                             ADMIN_API_REQUEST_ENABLE_ACME,
                             ADMIN_API_REQUEST_CREATE_SEAT,
                              ]
ADMIN_API_REQUEST_PARAM_NAME_AUTH_USERNAME = "auth-username"
ADMIN_API_REQUEST_PARAM_NAME_AUTH_PASSWORD = "auth-password"
ADMIN_API_REQUEST_PARAM_NAME_SERVICE_NAME = "service"
ADMIN_API_REQUEST_PARAM_NAME_DEVID_USERNAME = "deviduser"
ADMIN_API_REQUEST_PARAM_NAME_CN = "cn"
ADMIN_API_REQUEST_PARAM_NAME_SAN = "san"
ADMIN_API_REQUEST_PARAM_NAME_CSR = "csr"
ADMIN_API_REQUEST_PARAM_NAME_INCLUDE_SHARED_SETTINGS = "include-shared-settings"
ADMIN_API_REQUEST_PARAM_NAME_INCLUDE_DB_CONNECTION_SETTINGS = "include-db-connection-settings"
ADMIN_API_REQUEST_PARAM_NAME_INCLUDE_HSM_CONNECTION_SETTINGS = "include-hsm-connection-settings"
ADMIN_API_REQUEST_PARAM_NAME_INCLUDE_KEYTALK_CERT_TREE = "include-keytalk-cert-tree"
ADMIN_API_REQUEST_PARAM_NAME_INCLUDE_WEBAPI_SERVER_SETTINGS = "include-webapi-server-settings"
ADMIN_API_REQUEST_PARAM_NAME_INCLUDE_AAD_CERTWRITER_SETTINGS = "include-aad-cert-writer-settings"
ADMIN_API_REQUEST_PARAM_NAME_TEMPLATE_NAME = "template-name"
ADMIN_API_REQUEST_PARAM_NAME_SRC_TEMPLATE_NAME = "src-template-name"
ADMIN_API_REQUEST_PARAM_NAME_NEW_TEMPLATE_NAME = "new-template-name"
ADMIN_API_REQUEST_PARAM_NAME_DIGICERT_CENTRAL_SETTINGS = "digicert-central-settings"
ADMIN_API_REQUEST_PARAM_NAME_PRODUCT = "product"
ADMIN_API_REQUEST_PARAM_NAME_API_KEY = "api-key"
ADMIN_API_REQUEST_PARAM_NAME_CERT_VALIDITY_MONTHS = "cert-validity-months"
ADMIN_API_REQUEST_PARAM_NAME_ORGANIZATION_ID = "organization-id"
ADMIN_API_REQUEST_PARAM_NAME_ACCOUNT_REGION = "account-region"
ADMIN_API_REQUEST_PARAM_NAME_APPROVER_USER_ID = "approver-user-id"
ADMIN_API_REQUEST_PARAM_NAME_OWNER_NAME = "owner-name"
ADMIN_API_REQUEST_PARAM_NAME_CERTIFICATES = "certificates"
ADMIN_API_REQUEST_PARAM_NAME_CUSTOM = "custom"
ADMIN_API_REQUEST_PARAM_NAME_SEAT_NAME = "seat-name"
ADMIN_API_REQUEST_PARAM_NAME_NAME = "name"
ADMIN_API_REQUEST_PARAM_NAME_TPM_USAGE = "tpm-usage"
ADMIN_API_REQUEST_PARAM_NAME_TPM_CA_CERTS = "tpm-ca-certs"
ADMIN_API_REQUEST_PARAM_NAME_UNOCCUPIED_ONLY = "unoccupied-only"
ADMIN_API_REQUEST_PARAM_NAME_USER_NAME = "user-name"
ADMIN_API_REQUEST_PARAM_NAME_USER_PASSWORD = "user-password"
ADMIN_API_REQUEST_PARAM_NAME_USER_PASSWORD_TTL = "user-password-ttl"
ADMIN_API_REQUEST_PARAM_NAME_USER_PINCODE = "user-pincode"
ADMIN_API_REQUEST_PARAM_NAME_USER_CERT_SUBJECT = "user-cert-subject"
ADMIN_API_REQUEST_PARAM_NAME_USER_CERT_SAN = "user-cert-san"
ADMIN_API_REQUEST_PARAM_NAME_SEATS = "seats"
ADMIN_API_REQUEST_PARAM_NAME_MOBILE = "mobile"
ADMIN_API_REQUEST_PARAM_NAME_CERT_ID = "cert-id"
ADMIN_API_REQUEST_PARAM_NAME_DIGICERT_ACCOUNT_REGION = "digicert-account-region"
ADMIN_API_REQUEST_PARAM_NAME_DIGICERT_PRODUCT = "digicert-product"
ADMIN_API_REQUEST_PARAM_NAME_DIGICERT_API_KEY = "digicert-api-key"
ADMIN_API_REQUEST_PARAM_NAME_MAIL_FETCH_PROTO = "mail-fetch-proto"
ADMIN_API_REQUEST_PARAM_NAME_AZURE_CLIENT_ID = "azure-client-id"
ADMIN_API_REQUEST_PARAM_NAME_AZURE_CLIENT_SECRET = "azure-client-secret"
ADMIN_API_REQUEST_PARAM_NAME_AZURE_TENANT_ID = "azure-tenant-id"
ADMIN_API_REQUEST_PARAM_NAME_APPROVER_EMAIL = "approver-email"
ADMIN_API_REQUEST_PARAM_NAME_PURPOSE = "purpose"
ADMIN_API_REQUEST_PARAM_NAME_TENANT_NAME = "tenant-name"
ADMIN_API_REQUEST_PARAM_NAME_ASSIGNED_TEMPLATES = "assigned-templates"
ADMIN_API_REQUEST_PARAM_NAME_EXTERNAL_CUSTOMER_SETTINGS = "external-customer-settings"
ADMIN_API_REQUEST_PARAM_NAME_EXTERNAL_CUSTOMER_ORDER_ID = "external-customer-order-id"
ADMIN_API_REQUEST_PARAM_NAME_CUSTOMER_ID = "customer-id"
ADMIN_API_REQUEST_PARAM_NAME_ORDER_IDS = "order-ids"
ADMIN_API_REQUEST_PARAM_NAME_ERROR = "error"

ADMIN_API_RESPONSE_CERT_REVOCATION = "cert-revocation"
ADMIN_API_RESPONSE_CERT_ENROLLMENT = "cert-enrollment"
ADMIN_API_RESPONSE_CSR_ENROLLMENT_REQUIREMENTS = "csr-enrolment-requirements"
ADMIN_API_RESPONSE_SCEP_CONFIG = "scep-config"
ADMIN_API_RESPONSE_IMPORT_CERTS = "import-certs"
ADMIN_API_RESPONSE_ARCHIVE_SEAT = "archive-seat"
ADMIN_API_RESPONSE_REMOVE_SEAT = "remove-seat"
ADMIN_API_RESPONSE_SUCCESS = "success"
ADMIN_API_RESPONSE_ERROR = "error"
ADMIN_API_RESPONSE_STRINGS = [ADMIN_API_RESPONSE_CERT_REVOCATION,
                              ADMIN_API_RESPONSE_CERT_ENROLLMENT,
                              ADMIN_API_RESPONSE_CSR_ENROLLMENT_REQUIREMENTS,
                              ADMIN_API_RESPONSE_SCEP_CONFIG,
                              ADMIN_API_RESPONSE_IMPORT_CERTS,
                              ADMIN_API_RESPONSE_ARCHIVE_SEAT,
                              ADMIN_API_RESPONSE_REMOVE_SEAT,
                              ADMIN_API_RESPONSE_SUCCESS,
                              ADMIN_API_RESPONSE_ERROR,
                            ]
ADMIN_API_RESPONSE_PARAM_NAME_STATUS = "status"
ADMIN_API_RESPONSE_PARAM_NAME_ERROR = "error"
ADMIN_API_RESPONSE_PARAM_NAME_WARNING = "warning"
ADMIN_API_RESPONSE_PARAM_NAME_EXTRA_INFO = "extra-info"
ADMIN_API_RESPONSE_PARAM_NAME_NUM_REVOKED_CERTS = "num-revoked-certs"
ADMIN_API_RESPONSE_PARAM_NAME_CERT = "cert"
ADMIN_API_RESPONSE_PARAM_NAME_CREATED_USER_AUTH_PASSWORD = "created-user-auth-password"
ADMIN_API_RESPONSE_PARAM_NAME_KEY_SIZE = "key-size"
ADMIN_API_RESPONSE_PARAM_NAME_SIGNING_ALGO = "signing-algo"
ADMIN_API_RESPONSE_PARAM_NAME_SUBJECT = "subject"
ADMIN_API_RESPONSE_PARAM_NAME_SAN = "san"
ADMIN_API_RESPONSE_PARAM_NAME_ENABLED = "enabled"
ADMIN_API_RESPONSE_PARAM_NAME_SERVICE_NAME = "service-name"
ADMIN_API_RESPONSE_PARAM_NAME_RECIPIENT_CERT = "recipient-cert"
ADMIN_API_RESPONSE_PARAM_NAME_RECIPIENT_KEY = "recipient-key"
ADMIN_API_RESPONSE_PARAM_NAME_SIGNING_CERT = "signing-cert"
ADMIN_API_RESPONSE_PARAM_NAME_SIGNING_KEY = "signing-key"
ADMIN_API_RESPONSE_PARAM_NAME_ISSUER_CERTS = "issuer-certs"
ADMIN_API_RESPONSE_PARAM_NAME_IMPORTED = "imported"
ADMIN_API_RESPONSE_PARAM_NAME_SKIPPED = "skipped"
ADMIN_API_RESPONSE_PARAM_NAME_ARCHIVED = "archived"
ADMIN_API_RESPONSE_PARAM_NAME_REMOVED = "removed"
ADMIN_API_RESPONSE_PARAM_NAME_TPM_USAGE = "tpm-usage"
ADMIN_API_RESPONSE_PARAM_NAME_TPM_CA_CERTS = "tpm-ca-certs"
ADMIN_API_RESPONSE_PARAM_NAME_TEMPLATE_NAMES = "template-names"
ADMIN_API_RESPONSE_PARAM_NAME_CERT_ID = "cert-id"
ADMIN_API_RESPONSE_PARAM_NAME_ACME_DIRECTORY_URL = "acme-directory-url"
ADMIN_API_RESPONSE_PARAM_NAME_AZURE_URL = "azure-url"
ADMIN_API_RESPONSE_PARAM_NAME_AZURE_TENANT_ID = "azure-tenant-id"
ADMIN_API_RESPONSE_PARAM_NAME_AZURE_CLIENT_ID = "azure-client-id"
ADMIN_API_RESPONSE_PARAM_NAME_AZURE_CLIENT_SECRET = "azure-client-secret"
ADMIN_API_RESPONSE_PARAM_NAME_AZURE_TENANT_DOMAIN = "azure-tenant-domain"
ADMIN_API_RESPONSE_PARAM_NAME_AZURE_MS_GRAPH_URL = "azure-ms-graph-url"
ADMIN_API_RESPONSE_PARAM_NAME_EXTERNAL_CUSTOMER_RESERVED_SEATS = "external-customer-reserved-seats"
ADMIN_API_RESPONSE_PARAM_NAME_EXTERNAL_CUSTOMER_RESERVED_SEATS = "external-customer-reserved-seats"
ADMIN_API_RESPONSE_PARAM_NAME_RESULT = "result"

ADMIN_API_CREATE_SEAT_RESULT_CREATED = "created"
ADMIN_API_CREATE_SEAT_RESULT_UPDATED = "updated"
ADMIN_API_CREATE_SEAT_RESULT_STRINGS = [ADMIN_API_CREATE_SEAT_RESULT_CREATED,
                                         ADMIN_API_CREATE_SEAT_RESULT_UPDATED,
                               ]