#!/bin/bash

set -o errexit
set -o nounset


function restart_tomcat()
{
    for service in tomcat10 tomcat9 tomcat8 tomcat
    do
        if [[ -f "/usr/lib/systemd/system/${service}.service" || -f "/etc/systemd/system/${service}.service" ]] ; then
            systemctl restart "${service}.service"
            return 0
        elif [ -f "/etc/init.d/${service}" ] ; then
            service "${service}" restart
            return 0
        fi
    done

    echo "ERROR: No Tomcat installation found" >&2
    return 1
}


KEYSTORE_PASS="$1"
KEYSTORE_PATH="$2"
PFX_PATH=~/tmp/keytalk.pfx

if [ ! -f  "${PFX_PATH}" ]; then
    echo "KeyTalk Pfx certificate not found under ${PFX_PATH}" >&2
    exit 1
fi

cert_pass=$(cat ~/tmp/keytalk.pfx.pass)

openssl pkcs12 -in ${PFX_PATH} -clcerts -nokeys -out ~/tmp/keytalk.crt -password pass:$cert_pass
openssl pkcs12 -in ${PFX_PATH} -nocerts -nodes -out ~/tmp/keytalk_enc.key -password pass:$cert_pass
openssl rsa -in ~/tmp/keytalk_enc.key -out ~/tmp/keytalk.key >/dev/null
openssl pkcs12 -export -in ~/tmp/keytalk.crt -inkey ~/tmp/keytalk.key -out ~/tmp/keytalk_tomcat.pfx -password pass:"${KEYSTORE_PASS}"

echo "Importing certificate into tomcat keystore under ${KEYSTORE_PATH}"
keytool -noprompt -importkeystore -destkeystore "${KEYSTORE_PATH}" -deststorepass "${KEYSTORE_PASS}" -srckeystore ~/tmp/keytalk_tomcat.pfx -srcstorepass "${KEYSTORE_PASS}" -srcstoretype PKCS12

echo "Restarting tomcat"
restart_tomcat
