#!/bin/bash

set -e

function has_executable()
{
    if type "$1" > /dev/null 2>&1 && [ -x "$(type -p $1)" ]; then
        return 0
    else
        return 1
    fi
}

if ! has_executable lsb_release ; then
    if [ -f /etc/debian_version ]; then
        apt-get -qq -y update
        apt-get -y install lsb-release
        apt-get -y install libnss3-tools
    else
        echo "Ubuntu required for installation"
        exit 1
    fi
fi

OS_SPEC=$(lsb_release --id --short | tr "[:upper:]" "[:lower:]")-$(lsb_release --release --short | egrep -o [0-9]+ | sed -n 1p)-$(dpkg --print-architecture)
KTCLIENT_VERSION="7.9.0"
INSTALLER_FILENAME=KeyTalkClient-${KTCLIENT_VERSION}-${OS_SPEC}.tgz
if [ ! -f ${INSTALLER_FILENAME} ]; then
    echo "${INSTALLER_FILENAME} not found!" >&2
    exit 1
fi

rm -rf ./keytalkclient-${KTCLIENT_VERSION}
tar -xzf ${INSTALLER_FILENAME}

cd keytalkclient-${KTCLIENT_VERSION}
./install.sh
